<?php
// intro.php - restituisce intro.mp4 con supporto Range (seek/streaming Android)

$path = __DIR__ . '/intro.mp4';

if (!is_file($path)) {
    http_response_code(404);
    exit;
}

$size = filesize($path);
$start = 0;
$end   = $size - 1;

// Header base
header('Content-Type: video/mp4');
header('Accept-Ranges: bytes');
header('X-Content-Type-Options: nosniff');

$fp = fopen($path, 'rb');
if ($fp === false) {
    http_response_code(500);
    exit;
}

// Gestione Range: bytes=start-end
if (!empty($_SERVER['HTTP_RANGE']) && preg_match('/bytes=(\d+)-(\d*)/i', $_SERVER['HTTP_RANGE'], $m)) {
    $start = (int)$m[1];
    if ($m[2] !== '') {
        $end = (int)$m[2];
    }

    // Validazioni
    if ($start > $end || $start >= $size) {
        header("Content-Range: bytes */$size");
        http_response_code(416);
        fclose($fp);
        exit;
    }
    if ($end >= $size) {
        $end = $size - 1;
    }

    http_response_code(206);
    header("Content-Range: bytes $start-$end/$size");
}

$length = $end - $start + 1;
header("Content-Length: $length");

// Stream del file
fseek($fp, $start);

$chunkSize = 1024 * 1024; // 1MB
while (!feof($fp) && $length > 0) {
    $read = ($length > $chunkSize) ? $chunkSize : $length;
    $buffer = fread($fp, $read);
    if ($buffer === false) break;

    echo $buffer;
    flush();

    $length -= strlen($buffer);
}

fclose($fp);
exit;
